
CREATE FUNCTION [dbo].[CFUJ_Venta_Abonos_Condiciones_Validar](@pJson VARCHAR(8000))
RETURNS TINYINT
AS
BEGIN
/*Variable Retorno*/
DECLARE @Flag_Validacion_OK		TINYINT
/*FIN Variable Retorno*/

/*Variables recibidas por parametro a traves del JSON*/
DECLARE @pModoDebug			TINYINT
DECLARE @pId_Cliente		INT
DECLARE @pId_Evento			SMALLINT
DECLARE @pFecha				DATETIME

SET @pModoDebug				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), '')
SET @pId_Cliente			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Cliente')), 0)
SET @pId_Evento				= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Evento')), 0)
SET @pFecha					= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha')), GETDATE())
/*FIN Variables recibidas por parametro a traves del JSON*/

/*Variables Locales*/
DECLARE @Cliente_Activo									TINYINT
DECLARE @Cliente_Fecha_Alta								DATETIME
DECLARE @Cliente_Fecha_Baja								DATETIME
DECLARE @Cliente_Id_Cliente_Ref									INT
DECLARE @Cliente_Id_Cliente_Externo						VARCHAR(14)
DECLARE @Cliente_Razon_Social							VARCHAR(100)
DECLARE @Cliente_Fecha_Nac								DATETIME
DECLARE @Cliente_Edad									INT
DECLARE @Cliente_Id_Tipo_Cli							SMALLINT
DECLARE @Cliente_Doc_Nro								BIGINT
DECLARE @Cliente_Credencial_Nro							VARCHAR(30)
DECLARE @Cliente_Tipo_Persona							CHAR(1)
DECLARE @Cliente_Ult_Cuota_Paga							DATETIME

DECLARE @Evento_Activo									TINYINT
DECLARE @Evento_Descripcion								VARCHAR(45)
DECLARE @Evento_Fecha_Desde								DATETIME
DECLARE @Evento_Fecha_Hasta								DATETIME
DECLARE @Evento_Evento_Desde							DATETIME
DECLARE @Evento_Evento_Hasta							DATETIME
DECLARE @Evento_Fecha_Vta_Web_Desde						DATETIME
DECLARE @Evento_Fecha_Vta_Web_Hasta						DATETIME
DECLARE @Evento_Flag_Localidades						TINYINT
DECLARE @Evento_Flag_Web								TINYINT
DECLARE @Evento_Evento_Cant_Dias_Limite					INT
DECLARE @Evento_Evento_Fecha_Reserva_Limite				DATETIME
DECLARE @Evento_Id_Sede									SMALLINT

DECLARE @Dia_De_La_Semana								VARCHAR(50)
DECLARE @Hoy											DATE
DECLARE @Flag_Root										TINYINT
/*FIN Variables Locales*/

-----------------------------------------------------------------------------------------------------------------------------------------------

SELECT
@Cliente_Activo								= ISNULL(Activo, 0),
@Cliente_Fecha_Alta							= ISNULL(Fecha_Alta, '19000101'),
@Cliente_Fecha_Baja							= ISNULL(Fecha_Baja, '19000101'),
@Cliente_Id_Cliente_Ref						= ISNULL(Id_Cliente_Ref, 0),
@Cliente_Id_Cliente_Externo					= LTRIM(RTRIM(ISNULL(Id_Cliente_Externo, ''))),
@Cliente_Razon_Social						= LTRIM(RTRIM(ISNULL(Razon_Social, ''))),
@Cliente_Fecha_Nac							= ISNULL(Fecha_Nac, '19000101'),
@Cliente_Edad								= dbo.CF_Edad_Persona_A_UnaFecha(ISNULL(Fecha_Nac, '19000101'), @pFecha),
@Cliente_Id_Tipo_Cli						= ISNULL(Id_Tipo_Cli, 0),
@Cliente_Doc_Nro							= ISNULL(Doc_Nro, 0),
@Cliente_Credencial_Nro						= LTRIM(RTRIM(ISNULL(Credencial_Nro, ''))),
@Cliente_Tipo_Persona						= ISNULL(Tipo_Persona, 'F'), 
@Cliente_Ult_Cuota_Paga						= ISNULL(Ult_Cuota_Paga, '19000101')
FROM Clientes
WHERE
Id_Cliente = @pId_Cliente

-----------------------------------------------------------------------------------------------------------------------------------------------

/*SE HABILITA POR BACKDOOR*/
SELECT
@Flag_Root = ISNULL(Valor_Integer, 0)
FROM Clientes_XCampos
WHERE
Id_Campo = 103 /*ROOT*/
AND Id_Cliente = @pId_Cliente

IF(@Flag_Root=1)
BEGIN
	SET @Flag_Validacion_OK = 1
	RETURN @Flag_Validacion_OK
END

-----------------------------------------------------------------------------------------------------------------------------------------------

SELECT
@Evento_Activo							= ISNULL(Activo, 0),
@Evento_Descripcion						= LTRIM(RTRIM(ISNULL(Descripcion, ''))),
@Evento_Fecha_Desde						= ISNULL(Fecha_Desde, '19000101'),
@Evento_Fecha_Hasta						= ISNULL(Fecha_Hasta, '19000101'),
@Evento_Evento_Desde					= ISNULL(Evento_Desde, '19000101'),
@Evento_Evento_Hasta					= ISNULL(Evento_Hasta, '19000101'),
@Evento_Fecha_Vta_Web_Desde				= ISNULL(Fecha_Vta_Web_Desde, '19000101'),
@Evento_Fecha_Vta_Web_Hasta				= ISNULL(Fecha_Vta_Web_Hasta, '19000101'),
@Evento_Flag_Localidades				= ISNULL(Flag_Localidades, 0),
@Evento_Flag_Web						= ISNULL(Flag_Web, 0),
@Evento_Evento_Cant_Dias_Limite			= ISNULL(Evento_Cant_Dias_Limite, 0),
@Evento_Evento_Fecha_Reserva_Limite		= ISNULL(Evento_Fecha_Reserva_Limite, '19000101'),
@Evento_Id_Sede							= ISNULL(Id_Sede, 0)
FROM Prod_Listas_Precios
WHERE
Id_Lista_Precio = @pId_Evento

IF(CONVERT(DATE, @pFecha) <> CONVERT(DATE, GETDATE()))
BEGIN
	SET @Hoy				= CONVERT(DATE, @pFecha)
END
ELSE
BEGIN
	SET @Hoy				= CONVERT(DATE, GETDATE())
END

-----------------------------------------------------------------------------------------------------------------------------------------------

SET @Dia_De_La_Semana	= LTRIM(RTRIM(UPPER(DATENAME(WEEKDAY, @Hoy))))	/*LUNES, MARTES, MIERCOLES, JUEVES,....*/

-----------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------

--ULTIMA IMPLEMENTACION DD/MM/AAAA

-----------------------------------------------------------------------------------------------------------------------------------------------

IF(@Evento_Activo <> 1)
BEGIN
	SET @Flag_Validacion_OK = 0
	RETURN @Flag_Validacion_OK
END


IF(@Evento_Flag_Localidades <> 1 /*Evento en un periodo de tiempo*/)
BEGIN
	SET @Flag_Validacion_OK = 0
	RETURN @Flag_Validacion_OK
END

IF(@Evento_Flag_Web <> 1)
BEGIN
	SET @Flag_Validacion_OK = 0
	RETURN @Flag_Validacion_OK
END

IF(	CONVERT(DATE, @Evento_Fecha_Vta_Web_Desde) >= @Hoy
	AND CONVERT(DATE, @Evento_Fecha_Vta_Web_Hasta) <= @Hoy)
BEGIN
	SET @Flag_Validacion_OK = 0
	RETURN @Flag_Validacion_OK
END

-----------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------

IF(@Cliente_Activo <> 1)
BEGIN
	SET @Flag_Validacion_OK = 0
	RETURN @Flag_Validacion_OK
END

-----------------------------------------------------------------------------------------------------------------------------------------------

IF(@Cliente_Tipo_Persona <> 'F')
BEGIN
	SET @Flag_Validacion_OK = 0
	RETURN @Flag_Validacion_OK
END

-----------------------------------------------------------------------------------------------------------------------------------------------



-----------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------

-----------------------------------------------------------------------------------------------------------------------------------------------

--INICIALIZACION
SET @Flag_Validacion_OK = 1

-----------------------------------------------------------------------------------------------------------------------------------------------

IF(1 = 0)
BEGIN
	SET @Flag_Validacion_OK = 0
END

----------------------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------------------

--------------------------------------------------------------------------------------------------------------------------------
RETURN ISNULL(@Flag_Validacion_OK, 0)
END
--SELECT dbo.CFUJ_Venta_Abonos_Condiciones_Validar ('{"ModoDebug":"0","Id_Cliente":"37819","Id_Evento":"511","Fecha":"20220112"}')